package api.wsit.request_helper;
/*
 * ***************************************************************
 * , Copyright. HSBC Holdings plc ccyy ALL RIGHTS RESERVED.
 *
 * This software is only to be used for the purpose for which it
 * has been provided. No part of it is to be reproduced,
 * disassembled, transmitted, stored in a retrieval system or
 * translated in any human or computer language in any way or
 * for any other purposes whatsoever without the prior written
 * consent of HSBC Holdings plc.
 * ***************************************************************
 */

import config.ClientConfig;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKey;
import util.Projects;
import api.wsit.product_request.execute.ApiSchema;

import java.security.Security;
import java.util.HashMap;
import java.util.List;

import static security.KeyUtility.*;
import static util.JsonUtil.getStringFromFile;
import static api.wsit.request_helper.WsitApiRequest.processResponseMessage;


public class ProcessResponseMessage {

    // public static final Map<String, String> targetHostConfig = LoadTargetHostConfig(targetHost);


    /**
     * used to fix java.security.NoSuchProviderException: no such provider: BC
     */
    static {
        try {
            Security.addProvider(new BouncyCastleProvider());
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ProcessResponseMessage() {
    }

    public static void main(String[] args) throws Exception {
        HashMap<String, String> activeProjectSettings = Projects.LoadActiveProjectSettings();
        String clientHostingRegion = activeProjectSettings.get("clientHostingRegion");
        String clientProfileId = activeProjectSettings.get("clientProfileId");
        String oboProfileId = activeProjectSettings.get("oboProfileId");
        String bankPublicKeyFile = activeProjectSettings.get("bankPublicKeyFile");
        String clientPrivateKeyFile = activeProjectSettings.get("clientPrivateKeyFile");
        String clientPrivateKeyPassphrase = activeProjectSettings.get("clientPrivateKeyPassphrase");
        String responseMessageFile = ClientConfig.REQUEST_CONTENT_PATH + "/SampleResponseMessage.json";
        String apiSchema = ApiSchema.Edge.SCHEMA_NAME;
        Boolean isVerifySignature = false;
        HashMap <String, String> payloadWrappers = new HashMap<String, String>();
        switch (apiSchema) {
            case (ApiSchema.Edge.SCHEMA_NAME):
                payloadWrappers.put("request", "encryptedRequestBase64");
                payloadWrappers.put("response", "encryptedResponseBase64");
                break;
            case (ApiSchema.Gtrf.SCHEMA_NAME):
                isVerifySignature = false;
                payloadWrappers.put("request", null);
                payloadWrappers.put("response", null);
                break;
        }

        System.out.println("#1.1. Reading \"" + responseMessageFile + "\" as InputStream and converting to String...");
        String responseMessage = getStringFromFile(responseMessageFile);

        System.out.println("#2. Start of preparing the HTTP Request...");
        // 2.1 Preparing PGP Keys
        System.out.println("#2.1. Preparing PGP Keys...");
        // 2.1.1 Retrieves Bank PGP Public Keys
        List<PGPPublicKey> bankPgpPublicKeys = getPublicKeys(bankPublicKeyFile);
        PGPPublicKey bankPgpPublicKey = getEncryptionKey(apiSchema, bankPgpPublicKeys);
        // 2.1.2. Retrieves Client PGP Private Keys
        List<PGPPrivateKey> clientPgpPrivateKeys = getPrivateKeys(clientPrivateKeyFile, clientPrivateKeyPassphrase);
        System.out.println(Long.toHexString(clientPgpPrivateKeys.get(0).getKeyID()).toUpperCase());
        PGPPrivateKey clientPgpPrivateKey = clientPgpPrivateKeys.get(0);

        String decryptedMessage = processResponseMessage(payloadWrappers, responseMessage, bankPgpPublicKeys, clientPgpPrivateKeys, isVerifySignature);
    }


}
