package api.wsit.product_request;

import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import api.wsit.product_request.execute.ApiSchema;
import org.json.JSONObject;

import java.util.HashMap;
import static api.wsit.product_request.execute.ApiRequestExecutor.execute;
import static api.wsit.product_request.execute.ApiSchema.getRequestContentPath;

public class ExportCollection {

    public static final String API_PRODUCT_CATEGORY = "Export Collection";
    public static final String API_FOLDER = "/export-collection";
    
    
    

    public static class V3 extends ApiSchema.Edge {
        public static final String API_VERSION = "V3";

        public static class EnquireExportCollectionBillStatusSummary {
            public static final String API_NAME = "Enquire Export Collection Bill Status Summary";
            public static final String HTTP_METHOD = HttpGet.METHOD_NAME;
            public static final HashMap<String, String> REQUEST_URI_PARAMETERS = new HashMap<String, String>() {
                {
                    put("pageNumber", "1");
                    put("pageSize", "10");
                    put("billNumber","BPCOCB727872");
                    //put("status", "");
                    //put("startDate","");
                    //put("endDate","");
                }
            };
            public static HashMap<String, Object> TRADE_ACCOUNTS = new HashMap<String, Object>() {
                {
                    put("accountCountry", "SG");
                    put("institutionCode",  "HSBC");
                    put("accountNumbers", "141673301095");
                }
            };
            public static HashMap<String, Object> ADDITIONAL_TOKEN_CLAIMS = new HashMap<String, Object>() {
                {
                    put("claims", new HashMap<String, Object>());
                    put("claimsToEncrypt", new HashMap<String, Object>(){
                        {
                            put("tradeAccounts", new JSONObject(TRADE_ACCOUNTS));
                        }
                    });
                }
            };
            public static final HashMap<String, String> ADDITIONAL_REQUEST_HEADERS = new HashMap<String, String>();
            public static final String REQUEST_JSON_FILE = null;

            public static final HashMap<String, String> PAYLOAD_WRAPPERS = new HashMap<String, String>() {
                {
                    put("request", "encryptedRequestBase64");
                    put("response", "encryptedResponseBase64");
                }
            };
            public static final HashMap<String, String> API_ENDPOINT_URLS = new HashMap<String, String>() {
                {
                    put("SANDBOX", null);
                    put("UAT", "/cmb-gtrf-mkt-ea-collection-uat-external-proxy/v3/collections/export");
                    put("PRODUCTION", "");

                }
            };
            public static HashMap API_SETTINGS = new HashMap<String, Object>() {
                {
                    put("apiProductCategory", API_PRODUCT_CATEGORY);
                    put("apiVersion", API_VERSION);
                    put("apiName", API_NAME);
                    put("httpMethod", HTTP_METHOD);
                    put("apiEndpointUrls", API_ENDPOINT_URLS);
                    put("apiSchema", SCHEMA_NAME);
                    put("requestUriParameters", REQUEST_URI_PARAMETERS);
                    put("additionalTokenClaims",ADDITIONAL_TOKEN_CLAIMS);
                    put("contentType", CONTENT_TYPE);
                    put("additionalRequestHeaders", ADDITIONAL_REQUEST_HEADERS);
                    put("requestJsonFile", REQUEST_JSON_FILE);
                    put("xHsbcCryptoSignature", X_HSBC_CRYPTO_SIGNATURE);
                    put("payloadWrappers", PAYLOAD_WRAPPERS);
                }
            };

            public EnquireExportCollectionBillStatusSummary() {
            }

            public static void main(String[] args) {
                try {
                    execute(API_SETTINGS);
                } catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        public static class EnquireExportCollectionBillDetail {
            public static final String API_NAME = "Enquire Export DC Bill Detail";
            public static final String HTTP_METHOD = HttpPost.METHOD_NAME;
            public static final HashMap<String, String> REQUEST_URI_PARAMETERS = new HashMap<String, String>();
            public static final HashMap<String, String> ADDITIONAL_REQUEST_HEADERS = new HashMap<String, String>();
            public static final String REQUEST_JSON_FILE = getRequestContentPath(API_FOLDER, API_VERSION) + "/EnquireExportCollectionBillDetail.json";
            
            public static final HashMap<String, String> PAYLOAD_WRAPPERS = new HashMap<String, String>() {
                {
                    put("request", "encryptedRequestBase64");
                    put("response", "encryptedResponseBase64");
                }
            };
            public static final HashMap<String, String> API_ENDPOINT_URLS = new HashMap<String, String>() {
                {
                    put("SANDBOX", null);
                    put("UAT", null);
                    put("PRODUCTION", "");

                }
            };
            public static HashMap API_SETTINGS = new HashMap<String, Object>() {
                {
                    put("apiProductCategory", API_PRODUCT_CATEGORY);
                    put("apiName", API_NAME);
                    put("httpMethod", HTTP_METHOD);
                    put("apiEndpointUrls", API_ENDPOINT_URLS);
                    put("apiSchema", SCHEMA_NAME);
                    put("requestUriParameters", REQUEST_URI_PARAMETERS);
                    put("additionalRequestHeaders", ADDITIONAL_REQUEST_HEADERS);
                    put("requestJsonFile", REQUEST_JSON_FILE);
                    put("xHsbcCryptoSignature", X_HSBC_CRYPTO_SIGNATURE);
                    put("payloadWrappers", PAYLOAD_WRAPPERS);
                }
            };

            public EnquireExportCollectionBillDetail() {
            }

            public static void main(String[] args) {
                try {
                    execute(API_SETTINGS);
                } catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }

    }



    public static class V1 extends ApiSchema.Gtrf {
        public static final String API_VERSION = "V1";

        public static class EnquireExportCollectionBillStatusSummary {
            public static final String API_NAME = "Enquire Export Collection Bill Status Summary";
            public static final String HTTP_METHOD = HttpPost.METHOD_NAME;
            public static final HashMap<String, String> REQUEST_URI_PARAMETERS = new HashMap<String, String>();
            public static final HashMap<String, String> ADDITIONAL_REQUEST_HEADERS = new HashMap<String, String>();
            public static final String REQUEST_JSON_FILE = getRequestContentPath(API_FOLDER, API_VERSION) + "/EnquireExportCollectionBillStatusSummary.json";
            
            public static final HashMap<String, String> PAYLOAD_WRAPPERS = new HashMap<String, String>() {
                {
                    put("request", "encryptedRequestBase64");
                    put("response", "encryptedResponseBase64");
                }
            };
            public static final HashMap<String, String> API_ENDPOINT_URLS = new HashMap<String, String>() {
                {
                    put("SANDBOX", null);
                    put("UAT", "/cmb-gtrf-mkt-trade-sa-ods-bill-uat-external-proxy/v1/eb2b/trade-tracker/ex-nondc-bill-s");
                    put("PRODUCTION", "");

                }
            };
            public static HashMap API_SETTINGS = new HashMap<String, Object>() {
                {
                    put("apiProductCategory", API_PRODUCT_CATEGORY);
                    put("apiName", API_NAME);
                    put("httpMethod", HTTP_METHOD);
                    put("apiEndpointUrls", API_ENDPOINT_URLS);
                    put("apiSchema", SCHEMA_NAME);
                    put("requestUriParameters", REQUEST_URI_PARAMETERS);
                    put("additionalRequestHeaders", ADDITIONAL_REQUEST_HEADERS);
                    put("requestJsonFile", REQUEST_JSON_FILE);
                    put("xHsbcCryptoSignature", X_HSBC_CRYPTO_SIGNATURE);
                    put("payloadWrappers", PAYLOAD_WRAPPERS);
                }
            };

            public EnquireExportCollectionBillStatusSummary() {
            }

            public static void main(String[] args) {
                try {
                    execute(API_SETTINGS);
                } catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        public static class EnquireExportCollectionBillDetail {
            public static final String API_NAME = "Enquire Export DC Bill Detail";
            public static final String HTTP_METHOD = HttpPost.METHOD_NAME;
            public static final HashMap<String, String> REQUEST_URI_PARAMETERS = new HashMap<String, String>();
            public static final HashMap<String, String> ADDITIONAL_REQUEST_HEADERS = new HashMap<String, String>();
            public static final String REQUEST_JSON_FILE = getRequestContentPath(API_FOLDER, API_VERSION) + "/EnquireExportCollectionBillDetail.json";
            
            public static final HashMap<String, String> PAYLOAD_WRAPPERS = new HashMap<String, String>() {
                {
                    put("request", "encryptedRequestBase64");
                    put("response", "encryptedResponseBase64");
                }
            };
            public static final HashMap<String, String> API_ENDPOINT_URLS = new HashMap<String, String>() {
                {
                    put("SANDBOX", null);
                    put("UAT", "/cmb-gtrf-mkt-trade-sa-ods-bill-uat-external-proxy/v1/eb2b/trade-tracker/ex-nondc-bill-s");
                    put("PRODUCTION", "");

                }
            };
            public static HashMap API_SETTINGS = new HashMap<String, Object>() {
                {
                    put("apiProductCategory", API_PRODUCT_CATEGORY);
                    put("apiName", API_NAME);
                    put("httpMethod", HTTP_METHOD);
                    put("apiEndpointUrls", API_ENDPOINT_URLS);
                    put("apiSchema", SCHEMA_NAME);
                    put("requestUriParameters", REQUEST_URI_PARAMETERS);
                    put("additionalRequestHeaders", ADDITIONAL_REQUEST_HEADERS);
                    put("requestJsonFile", REQUEST_JSON_FILE);
                    put("xHsbcCryptoSignature", X_HSBC_CRYPTO_SIGNATURE);
                    put("payloadWrappers", PAYLOAD_WRAPPERS);
                }
            };

            public EnquireExportCollectionBillDetail() {
            }

            public static void main(String[] args) {
                try {
                    execute(API_SETTINGS);
                } catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }
}

