package api.wsit.product_request;

import api.wsit.product_request.execute.ApiSchema;
import com.alibaba.fastjson.JSON;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.HashMap;

import static api.wsit.product_request.execute.ApiRequestExecutor.execute;
import static api.wsit.product_request.execute.ApiSchema.getRequestContentPath;
import static security.MessageLevel.encrypt;

public class BankGuarantee {

    public static final String API_PRODUCT_CATEGORY = "Bank Guarantee";
    public static final String API_FOLDER = "/bank-guarantee";


    public static class V3 extends ApiSchema.Edge {
        public static final String API_VERSION = "V3";

        public static class SubmitBankGuaranteeApplications {
            public static final String API_NAME = "Submit Bank Guarantee Applications";
            public static final String HTTP_METHOD = HttpPost.METHOD_NAME;
            public static final HashMap<String, String> REQUEST_URI_PARAMETERS = new HashMap<String, String>();
            public static final HashMap<String, String> ADDITIONAL_REQUEST_HEADERS = new HashMap<String, String>();
            public static HashMap<String, String> TRADE_ACCOUNT = new HashMap<String, String>() {
                {
                    put("accountCountry", "GB");
                    put("institutionCode",  "MDBK");
                    put("accountNumbers", "611012089586");
                }
            };
            public static HashMap<String, Object> ADDITIONAL_TOKEN_CLAIMS = new HashMap<String, Object>() {
                {
                    put("claims", new HashMap<String, Object>());
                    put("claimsToEncrypt", new HashMap<String, Object>(){
                        {
                            put("tradeAccounts", new JSONObject(TRADE_ACCOUNT));
                        }
                    });
                }
            };
            public static final String REQUEST_JSON_FILE = getRequestContentPath(API_FOLDER, API_VERSION) + "/SubmitBankGuaranteeApplications.json";

            public static final HashMap<String, String> PAYLOAD_WRAPPERS = new HashMap<String, String>() {
                {
                    put("request", "encryptedRequestBase64");
                    put("response", "encryptedResponseBase64");
                }
            };
            public static final HashMap<String, String> API_ENDPOINT_URLS = new HashMap<String, String>() {
                {
                    put("SANDBOX", null);
                    put("UAT",  "/cmb-gtrf-mkt-ea-gte-sdc-uat-external-proxy/v3/bank-guarantees/applications");
                    put("PRODUCTION", "");

                }
            };
            public static HashMap API_SETTINGS = new HashMap<String, Object>() {
                {
                    put("apiProductCategory", API_PRODUCT_CATEGORY);
                    put("apiVersion", API_VERSION);
                    put("apiName", API_NAME);
                    put("httpMethod", HTTP_METHOD);
                    put("apiEndpointUrls", API_ENDPOINT_URLS);
                    put("apiSchema", SCHEMA_NAME);
                    put("requestUriParameters", REQUEST_URI_PARAMETERS);
                    put("additionalTokenClaims",ADDITIONAL_TOKEN_CLAIMS);
                    put("contentType", CONTENT_TYPE);
                    put("additionalRequestHeaders", ADDITIONAL_REQUEST_HEADERS);
                    put("requestJsonFile", REQUEST_JSON_FILE);
                    put("xHsbcCryptoSignature", X_HSBC_CRYPTO_SIGNATURE);
                    put("payloadWrappers", PAYLOAD_WRAPPERS);
                }
            };

            public SubmitBankGuaranteeApplications() {
            }

            public static void main(String[] args) {
                try {
                    execute(API_SETTINGS);
                } catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        public static class SubmitBankGuaranteeAmendments {
            public static final String API_NAME = "Submit Bank Guarantee Amendments";
            public static final String HTTP_METHOD = HttpPost.METHOD_NAME;
            public static final HashMap<String, String> REQUEST_URI_PARAMETERS = new HashMap<String, String>();
            public static final HashMap<String, String> ADDITIONAL_REQUEST_HEADERS = new HashMap<String, String>();
            public static HashMap<String, String> TRADE_ACCOUNT = new HashMap<String, String>() {
                {
                    put("accountCountry", "SG");
                    put("institutionCode",  "HSBC");
                    put("accountNumbers", "123456789");
                }
            };
            public static HashMap<String, Object> ADDITIONAL_TOKEN_CLAIMS = new HashMap<String, Object>() {
                {
                    put("claims", new HashMap<String, Object>());
                    put("claimsToEncrypt", new HashMap<String, Object>(){
                        {
                            put("tradeAccounts", new JSONObject(TRADE_ACCOUNT));
                        }
                    });
                }
            };
            public static final String REQUEST_JSON_FILE = getRequestContentPath(API_FOLDER, API_VERSION) + "/SubmitBankGuaranteeAmendments.json";

            public static final HashMap<String, String> PAYLOAD_WRAPPERS = new HashMap<String, String>() {
                {
                    put("request", "encryptedRequestBase64");
                    put("response", "encryptedResponseBase64");
                }
            };
            public static final HashMap<String, String> API_ENDPOINT_URLS = new HashMap<String, String>() {
                {
                    put("SANDBOX", null);
                    put("UAT",  "/cmb-gtrf-mkt-ea-gte-sdc-uat-external-proxy/v3/bank-guarantees/amendment-applications");
                    put("PRODUCTION", "");

                }
            };
            public static HashMap API_SETTINGS = new HashMap<String, Object>() {
                {
                    put("apiProductCategory", API_PRODUCT_CATEGORY);
                    put("apiVersion", API_VERSION);
                    put("apiName", API_NAME);
                    put("httpMethod", HTTP_METHOD);
                    put("apiEndpointUrls", API_ENDPOINT_URLS);
                    put("apiSchema", SCHEMA_NAME);
                    put("requestUriParameters", REQUEST_URI_PARAMETERS);
                    put("additionalTokenClaims",ADDITIONAL_TOKEN_CLAIMS);
                    put("contentType", CONTENT_TYPE);
                    put("additionalRequestHeaders", ADDITIONAL_REQUEST_HEADERS);
                    put("requestJsonFile", REQUEST_JSON_FILE);
                    put("xHsbcCryptoSignature", X_HSBC_CRYPTO_SIGNATURE);
                    put("payloadWrappers", PAYLOAD_WRAPPERS);
                }
            };

            public SubmitBankGuaranteeAmendments() {
            }

            public static void main(String[] args) {
                try {
                    execute(API_SETTINGS);
                } catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        public static class QueryBankGuaranteeStatus {
            public static final String API_NAME = "Enquire Bank Guarantee Status";
            public static final String HTTP_METHOD = HttpGet.METHOD_NAME;
            public static final HashMap<String, String> REQUEST_URI_PARAMETERS = new HashMap<String, String>() {
                {
                    put("pageSize", "10");
                    put("pageNumber", "1");
                    //put("issuedDateFrom", "2024-08-31");
                    //put("issuedDateTo", "2024-12-31");
                    //put("expiryDateFrom", "2024-08-31");
                    //put("expiryDateTo", "2024-023-31");
                    //put("status", "Issued");

                }
            };
            public static final HashMap<String, String> ADDITIONAL_REQUEST_HEADERS = new HashMap<String, String>();
            public static final String REQUEST_JSON_FILE = null;
            public static HashMap<String, String> TRADE_ACCOUNT = new HashMap<String, String>() {
                {
                    put("accountCountry", "GB");
                    put("institutionCode",  "MDBK");
                    put("accountNumbers", "611012089590");
                }
            };
            public static HashMap<String, Object> ADDITIONAL_TOKEN_CLAIMS = new HashMap<String, Object>() {
                {
                    put("claims", new HashMap<String, Object>());
                    put("claimsToEncrypt", new HashMap<String, Object>(){
                        {
                            put("tradeAccounts", new JSONObject(TRADE_ACCOUNT));
                        }
                    });
                }
            };
            public static final HashMap<String, String> PAYLOAD_WRAPPERS = new HashMap<String, String>() {
                {
                    put("request", "encryptedRequestBase64");
                    put("response", "encryptedResponseBase64");
                }
            };
            public static final HashMap<String, String> API_ENDPOINT_URLS = new HashMap<String, String>() {
                {
                    put("SANDBOX", null);
                    put("UAT",  "/cmb-gtrf-mkt-ea-gte-sdc-uat-external-proxy/v3/bank-guarantees");
                    put("PRODUCTION", "");

                }
            };
            public static HashMap API_SETTINGS = new HashMap<String, Object>() {
                {
                    put("apiProductCategory", API_PRODUCT_CATEGORY);
                    put("apiVersion", API_VERSION);
                    put("apiName", API_NAME);
                    put("httpMethod", HTTP_METHOD);
                    put("apiEndpointUrls", API_ENDPOINT_URLS);
                    put("apiSchema", SCHEMA_NAME);
                    put("requestUriParameters", REQUEST_URI_PARAMETERS);
                    put("additionalTokenClaims",ADDITIONAL_TOKEN_CLAIMS);
                    put("contentType", CONTENT_TYPE);
                    put("additionalRequestHeaders", ADDITIONAL_REQUEST_HEADERS);
                    put("requestJsonFile", REQUEST_JSON_FILE);
                    put("xHsbcCryptoSignature", X_HSBC_CRYPTO_SIGNATURE);
                    put("payloadWrappers", PAYLOAD_WRAPPERS);
                }
            };

            public QueryBankGuaranteeStatus() {
            }

            public static void main(String[] args) {
                try {
                    execute(API_SETTINGS);
                } catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        public static class QueryBankGuaranteeDocuments {
            public static final String API_NAME = "Enquire Bank Guarantee Documents";
            public static final String HTTP_METHOD = HttpGet.METHOD_NAME;
            public static final HashMap<String, String> REQUEST_URI_PARAMETERS = new HashMap<String, String>() {
                {
                    put("guaranteeStandbyDcNumber", "1234567890");

                }
            };
            public static final HashMap<String, String> ADDITIONAL_REQUEST_HEADERS = new HashMap<String, String>();
            public static final String REQUEST_JSON_FILE = null;
            public static HashMap<String, String> TRADE_ACCOUNT = new HashMap<String, String>() {
                {
                    put("accountCountry", "SG");
                    put("institutionCode",  "HSBC");
                    put("accountNumbers", "123456789012");
                }
            };
            public static HashMap<String, Object> ADDITIONAL_TOKEN_CLAIMS = new HashMap<String, Object>() {
                {
                    put("claims", new HashMap<String, Object>());
                    put("claimsToEncrypt", new HashMap<String, Object>(){
                        {
                            put("tradeAccounts", new JSONObject(TRADE_ACCOUNT));
                        }
                    });
                }
            };
            public static final HashMap<String, String> PAYLOAD_WRAPPERS = new HashMap<String, String>() {
                {
                    put("request", "encryptedRequestBase64");
                    put("response", "encryptedResponseBase64");
                }
            };
            public static final HashMap<String, String> API_ENDPOINT_URLS = new HashMap<String, String>() {
                {
                    put("SANDBOX", null);
                    put("UAT",  "/cmb-gtrf-mkt-ea-gte-sdc-uat-external-proxy/v3/bank-guarantees/image-details");
                    put("PRODUCTION", "");

                }
            };
            public static HashMap API_SETTINGS = new HashMap<String, Object>() {
                {
                    put("apiProductCategory", API_PRODUCT_CATEGORY);
                    put("apiVersion", API_VERSION);
                    put("apiName", API_NAME);
                    put("httpMethod", HTTP_METHOD);
                    put("apiEndpointUrls", API_ENDPOINT_URLS);
                    put("apiSchema", SCHEMA_NAME);
                    put("requestUriParameters", REQUEST_URI_PARAMETERS);
                    put("additionalTokenClaims",ADDITIONAL_TOKEN_CLAIMS);
                    put("contentType", CONTENT_TYPE);
                    put("additionalRequestHeaders", ADDITIONAL_REQUEST_HEADERS);
                    put("requestJsonFile", REQUEST_JSON_FILE);
                    put("xHsbcCryptoSignature", X_HSBC_CRYPTO_SIGNATURE);
                    put("payloadWrappers", PAYLOAD_WRAPPERS);
                }
            };

            public QueryBankGuaranteeDocuments() {
            }

            public static void main(String[] args) {
                try {
                    execute(API_SETTINGS);
                } catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        public static class SubmitStandbyDcApplications {
            public static final String API_NAME = "Submit Standby DC Applications";
            public static final String HTTP_METHOD = HttpPost.METHOD_NAME;
            public static final HashMap<String, String> REQUEST_URI_PARAMETERS = new HashMap<String, String>();
            public static final HashMap<String, String> ADDITIONAL_REQUEST_HEADERS = new HashMap<String, String>();
            public static HashMap<String, String> TRADE_ACCOUNT = new HashMap<String, String>() {
                {
                    put("accountCountry", "SG");
                    put("institutionCode",  "HSBC");
                    put("accountNumbers", "123456789");
                }
            };
            public static HashMap<String, Object> ADDITIONAL_TOKEN_CLAIMS = new HashMap<String, Object>() {
                {
                    put("claims", new HashMap<String, Object>());
                    put("claimsToEncrypt", new HashMap<String, Object>(){
                        {
                            put("tradeAccounts", new JSONObject(TRADE_ACCOUNT));
                        }
                    });
                }
            };
            public static final String REQUEST_JSON_FILE = getRequestContentPath(API_FOLDER, API_VERSION) + "/SubmitStandbyDcApplications.json";

            public static final HashMap<String, String> PAYLOAD_WRAPPERS = new HashMap<String, String>() {
                {
                    put("request", "encryptedRequestBase64");
                    put("response", "encryptedResponseBase64");
                }
            };
            public static final HashMap<String, String> API_ENDPOINT_URLS = new HashMap<String, String>() {
                {
                    put("SANDBOX", null);
                    put("UAT",  "/cmb-gtrf-mkt-ea-gte-sdc-uat-external-proxy/v3/standby-dc/applications");
                    put("PRODUCTION", "");

                }
            };
            public static HashMap API_SETTINGS = new HashMap<String, Object>() {
                {
                    put("apiProductCategory", API_PRODUCT_CATEGORY);
                    put("apiVersion", API_VERSION);
                    put("apiName", API_NAME);
                    put("httpMethod", HTTP_METHOD);
                    put("apiEndpointUrls", API_ENDPOINT_URLS);
                    put("apiSchema", SCHEMA_NAME);
                    put("requestUriParameters", REQUEST_URI_PARAMETERS);
                    put("additionalTokenClaims",ADDITIONAL_TOKEN_CLAIMS);
                    put("contentType", CONTENT_TYPE);
                    put("additionalRequestHeaders", ADDITIONAL_REQUEST_HEADERS);
                    put("requestJsonFile", REQUEST_JSON_FILE);
                    put("xHsbcCryptoSignature", X_HSBC_CRYPTO_SIGNATURE);
                    put("payloadWrappers", PAYLOAD_WRAPPERS);
                }
            };

            public SubmitStandbyDcApplications() {
            }

            public static void main(String[] args) {
                try {
                    execute(API_SETTINGS);
                } catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        public static class SubmitStandbyDcAmendments {
            public static final String API_NAME = "Submit Standby DC Amendments";
            public static final String HTTP_METHOD = HttpPost.METHOD_NAME;
            public static final HashMap<String, String> REQUEST_URI_PARAMETERS = new HashMap<String, String>();
            public static final HashMap<String, String> ADDITIONAL_REQUEST_HEADERS = new HashMap<String, String>();
            public static HashMap<String, String> TRADE_ACCOUNT = new HashMap<String, String>() {
                {
                    put("accountCountry", "SG");
                    put("institutionCode",  "HSBC");
                    put("accountNumbers", "123456789");
                }
            };
            public static HashMap<String, Object> ADDITIONAL_TOKEN_CLAIMS = new HashMap<String, Object>() {
                {
                    put("claims", new HashMap<String, Object>());
                    put("claimsToEncrypt", new HashMap<String, Object>(){
                        {
                            put("tradeAccounts", new JSONObject(TRADE_ACCOUNT));
                        }
                    });
                }
            };
            public static final String REQUEST_JSON_FILE = getRequestContentPath(API_FOLDER, API_VERSION) + "/SubmitStandbyDcAmendments.json";

            public static final HashMap<String, String> PAYLOAD_WRAPPERS = new HashMap<String, String>() {
                {
                    put("request", "encryptedRequestBase64");
                    put("response", "encryptedResponseBase64");
                }
            };
            public static final HashMap<String, String> API_ENDPOINT_URLS = new HashMap<String, String>() {
                {
                    put("SANDBOX", null);
                    put("UAT",  "/cmb-gtrf-mkt-ea-gte-sdc-uat-external-proxy/v3/standby-dc/amendment-applications");
                    put("PRODUCTION", "");

                }
            };
            public static HashMap API_SETTINGS = new HashMap<String, Object>() {
                {
                    put("apiProductCategory", API_PRODUCT_CATEGORY);
                    put("apiVersion", API_VERSION);
                    put("apiName", API_NAME);
                    put("httpMethod", HTTP_METHOD);
                    put("apiEndpointUrls", API_ENDPOINT_URLS);
                    put("apiSchema", SCHEMA_NAME);
                    put("requestUriParameters", REQUEST_URI_PARAMETERS);
                    put("additionalTokenClaims",ADDITIONAL_TOKEN_CLAIMS);
                    put("contentType", CONTENT_TYPE);
                    put("additionalRequestHeaders", ADDITIONAL_REQUEST_HEADERS);
                    put("requestJsonFile", REQUEST_JSON_FILE);
                    put("xHsbcCryptoSignature", X_HSBC_CRYPTO_SIGNATURE);
                    put("payloadWrappers", PAYLOAD_WRAPPERS);
                }
            };

            public SubmitStandbyDcAmendments() {
            }

            public static void main(String[] args) {
                try {
                    execute(API_SETTINGS);
                } catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        public static class QueryStandbyDcStatus {
            public static final String API_NAME = "Enquire Standby DC Status";
            public static final String HTTP_METHOD = HttpGet.METHOD_NAME;
            public static final HashMap<String, String> REQUEST_URI_PARAMETERS = new HashMap<String, String>() {
                {
                    put("pageSize", "10");
                    put("pageNumber", "1");
                    //put("issuedDateFrom", "2024-08-31");
                    //put("issuedDateTo", "2024-12-31");
                    //put("expiryDateFrom", "2024-08-31");
                    //put("expiryDateTo", "2024-023-31");
                    //put("status", "Issued");

                }
            };
            public static final HashMap<String, String> ADDITIONAL_REQUEST_HEADERS = new HashMap<String, String>();
            public static final String REQUEST_JSON_FILE = null;
            public static HashMap<String, String> TRADE_ACCOUNT = new HashMap<String, String>() {
                {
                    put("accountCountry", "SG");
                    put("institutionCode",  "HSBC");
                    put("accountNumbers", "123456789012");
                }
            };
            public static HashMap<String, Object> ADDITIONAL_TOKEN_CLAIMS = new HashMap<String, Object>() {
                {
                    put("claims", new HashMap<String, Object>());
                    put("claimsToEncrypt", new HashMap<String, Object>(){
                        {
                            put("tradeAccounts", new JSONObject(TRADE_ACCOUNT));
                        }
                    });
                }
            };
            public static final HashMap<String, String> PAYLOAD_WRAPPERS = new HashMap<String, String>() {
                {
                    put("request", "encryptedRequestBase64");
                    put("response", "encryptedResponseBase64");
                }
            };
            public static final HashMap<String, String> API_ENDPOINT_URLS = new HashMap<String, String>() {
                {
                    put("SANDBOX", null);
                    put("UAT",  "/cmb-gtrf-mkt-ea-gte-sdc-uat-external-proxy/v3/standby-dcs/");
                    put("PRODUCTION", "");

                }
            };
            public static HashMap API_SETTINGS = new HashMap<String, Object>() {
                {
                    put("apiProductCategory", API_PRODUCT_CATEGORY);
                    put("apiVersion", API_VERSION);
                    put("apiName", API_NAME);
                    put("httpMethod", HTTP_METHOD);
                    put("apiEndpointUrls", API_ENDPOINT_URLS);
                    put("apiSchema", SCHEMA_NAME);
                    put("requestUriParameters", REQUEST_URI_PARAMETERS);
                    put("additionalTokenClaims",ADDITIONAL_TOKEN_CLAIMS);
                    put("contentType", CONTENT_TYPE);
                    put("additionalRequestHeaders", ADDITIONAL_REQUEST_HEADERS);
                    put("requestJsonFile", REQUEST_JSON_FILE);
                    put("xHsbcCryptoSignature", X_HSBC_CRYPTO_SIGNATURE);
                    put("payloadWrappers", PAYLOAD_WRAPPERS);
                }
            };

            public QueryStandbyDcStatus() {
            }

            public static void main(String[] args) {
                try {
                    execute(API_SETTINGS);
                } catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        public static class QueryStandbyDcDocuments {
            public static final String API_NAME = "Enquire Standby DC Documents";
            public static final String HTTP_METHOD = HttpGet.METHOD_NAME;
            public static final HashMap<String, String> REQUEST_URI_PARAMETERS = new HashMap<String, String>() {
                {
                    put("guaranteeStandbyDcNumber", "1234567890");

                }
            };
            public static final HashMap<String, String> ADDITIONAL_REQUEST_HEADERS = new HashMap<String, String>();
            public static final String REQUEST_JSON_FILE = null;
            public static HashMap<String, String> TRADE_ACCOUNT = new HashMap<String, String>() {
                {
                    put("accountCountry", "SG");
                    put("institutionCode",  "HSBC");
                    put("accountNumbers", "123456789012");
                }
            };
            public static HashMap<String, Object> ADDITIONAL_TOKEN_CLAIMS = new HashMap<String, Object>() {
                {
                    put("claims", new HashMap<String, Object>());
                    put("claimsToEncrypt", new HashMap<String, Object>(){
                        {
                            put("tradeAccounts", new JSONObject(TRADE_ACCOUNT));
                        }
                    });
                }
            };
            public static final HashMap<String, String> PAYLOAD_WRAPPERS = new HashMap<String, String>() {
                {
                    put("request", "encryptedRequestBase64");
                    put("response", "encryptedResponseBase64");
                }
            };
            public static final HashMap<String, String> API_ENDPOINT_URLS = new HashMap<String, String>() {
                {
                    put("SANDBOX", null);
                    put("UAT",  "/cmb-gtrf-mkt-ea-gte-sdc-uat-external-proxy/v3/standby-dcs/image-details");
                    put("PRODUCTION", "");

                }
            };
            public static HashMap API_SETTINGS = new HashMap<String, Object>() {
                {
                    put("apiProductCategory", API_PRODUCT_CATEGORY);
                    put("apiVersion", API_VERSION);
                    put("apiName", API_NAME);
                    put("httpMethod", HTTP_METHOD);
                    put("apiEndpointUrls", API_ENDPOINT_URLS);
                    put("apiSchema", SCHEMA_NAME);
                    put("requestUriParameters", REQUEST_URI_PARAMETERS);
                    put("additionalTokenClaims",ADDITIONAL_TOKEN_CLAIMS);
                    put("contentType", CONTENT_TYPE);
                    put("additionalRequestHeaders", ADDITIONAL_REQUEST_HEADERS);
                    put("requestJsonFile", REQUEST_JSON_FILE);
                    put("xHsbcCryptoSignature", X_HSBC_CRYPTO_SIGNATURE);
                    put("payloadWrappers", PAYLOAD_WRAPPERS);
                }
            };

            public QueryStandbyDcDocuments() {
            }

            public static void main(String[] args) {
                try {
                    execute(API_SETTINGS);
                } catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }

    }



    public static class V1 extends ApiSchema.Gtrf {
        public static final String API_VERSION = "V1";

        public static class QueryBankGuaranteeStatus {
            public static final String API_NAME = "Enquire Bank Guarantee Status";
            public static final String HTTP_METHOD = HttpPost.METHOD_NAME;
            public static final HashMap<String, String> REQUEST_URI_PARAMETERS = new HashMap<String, String>();
            public static final HashMap<String, String> ADDITIONAL_REQUEST_HEADERS = new HashMap<String, String>();
            public static final String REQUEST_JSON_FILE = getRequestContentPath(API_FOLDER, API_VERSION) + "/QueryBankGuaranteeStatus.json";
            
            public static final HashMap<String, String> PAYLOAD_WRAPPERS = new HashMap<String, String>() {
                {
                    put("request", null);
                    put("response", null);
                }
            };
            public static final HashMap<String, String> API_ENDPOINT_URLS = new HashMap<String, String>() {
                {
                    put("SANDBOX", "/v1/guarantee/fi/get-status");
                    put("UAT",  null);
                    put("PRODUCTION", "");

                }
            };
            public static HashMap API_SETTINGS = new HashMap<String, Object>() {
                {
                    put("apiProductCategory", API_PRODUCT_CATEGORY);
                    put("apiVersion", API_VERSION);
                    put("apiName", API_NAME);
                    put("httpMethod", HTTP_METHOD);
                    put("apiEndpointUrls", API_ENDPOINT_URLS);
                    put("apiSchema", SCHEMA_NAME);
                    put("requestUriParameters", REQUEST_URI_PARAMETERS);
                    put("contentType", CONTENT_TYPE);
                    put("additionalRequestHeaders", ADDITIONAL_REQUEST_HEADERS);
                    put("requestJsonFile", REQUEST_JSON_FILE);
                    put("xHsbcCryptoSignature", X_HSBC_CRYPTO_SIGNATURE);
                    put("payloadWrappers", PAYLOAD_WRAPPERS);
                }
            };

            public QueryBankGuaranteeStatus() {
            }

            public static void main(String[] args) {
                try {
                    execute(API_SETTINGS);
                } catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        public static class QueryStandbyDcStatus {
            public static final String API_NAME = "Enquire StandbyDC Status";
            public static final String HTTP_METHOD = HttpPost.METHOD_NAME;
            public static final HashMap<String, String> REQUEST_URI_PARAMETERS = new HashMap<String, String>();
            public static final HashMap<String, String> ADDITIONAL_REQUEST_HEADERS = new HashMap<String, String>();
            public static final String REQUEST_JSON_FILE = getRequestContentPath(API_FOLDER, API_VERSION) + "/QueryStandbyDcStatus.json";

            public static final HashMap<String, String> PAYLOAD_WRAPPERS = new HashMap<String, String>() {
                {
                    put("request", null);
                    put("response", null);
                }
            };
            public static final HashMap<String, String> API_ENDPOINT_URLS = new HashMap<String, String>() {
                {
                    put("SANDBOX", "/v1/standby-dc/fi/get-status");
                    put("UAT",  null);
                    put("PRODUCTION", "");

                }
            };
            public static HashMap API_SETTINGS = new HashMap<String, Object>() {
                {
                    put("apiProductCategory", API_PRODUCT_CATEGORY);
                    put("apiVersion", API_VERSION);
                    put("apiName", API_NAME);
                    put("httpMethod", HTTP_METHOD);
                    put("apiEndpointUrls", API_ENDPOINT_URLS);
                    put("apiSchema", SCHEMA_NAME);
                    put("requestUriParameters", REQUEST_URI_PARAMETERS);
                    put("contentType", CONTENT_TYPE);
                    put("additionalRequestHeaders", ADDITIONAL_REQUEST_HEADERS);
                    put("requestJsonFile", REQUEST_JSON_FILE);
                    put("xHsbcCryptoSignature", X_HSBC_CRYPTO_SIGNATURE);
                    put("payloadWrappers", PAYLOAD_WRAPPERS);
                }
            };

            public QueryStandbyDcStatus() {
            }

            public static void main(String[] args) {
                try {
                    execute(API_SETTINGS);
                } catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        public static class QueryBankGuaranteeDocuments {
            public static final String API_NAME = "Enquire Bank Guarantee Documents";
            public static final String HTTP_METHOD = HttpPost.METHOD_NAME;
            public static final HashMap<String, String> REQUEST_URI_PARAMETERS = new HashMap<String, String>();
            public static final HashMap<String, String> ADDITIONAL_REQUEST_HEADERS = new HashMap<String, String>();
            public static final String REQUEST_JSON_FILE = getRequestContentPath(API_FOLDER, API_VERSION) + "/QueryBankGuaranteeDocuments.json";

            public static final HashMap<String, String> PAYLOAD_WRAPPERS = new HashMap<String, String>() {
                {
                    put("request", null);
                    put("response", null);
                }
            };
            public static final HashMap<String, String> API_ENDPOINT_URLS = new HashMap<String, String>() {
                {
                    put("SANDBOX", "/v1/guarantee/get-documents");
                    put("UAT",  null);
                    put("PRODUCTION", "");

                }
            };
            public static HashMap API_SETTINGS = new HashMap<String, Object>() {
                {
                    put("apiProductCategory", API_PRODUCT_CATEGORY);
                    put("apiVersion", API_VERSION);
                    put("apiName", API_NAME);
                    put("httpMethod", HTTP_METHOD);
                    put("apiEndpointUrls", API_ENDPOINT_URLS);
                    put("apiSchema", SCHEMA_NAME);
                    put("requestUriParameters", REQUEST_URI_PARAMETERS);
                    put("contentType", CONTENT_TYPE);
                    put("additionalRequestHeaders", ADDITIONAL_REQUEST_HEADERS);
                    put("requestJsonFile", REQUEST_JSON_FILE);
                    put("xHsbcCryptoSignature", X_HSBC_CRYPTO_SIGNATURE);
                    put("payloadWrappers", PAYLOAD_WRAPPERS);
                }
            };

            public QueryBankGuaranteeDocuments() {
            }

            public static void main(String[] args) {
                try {
                    execute(API_SETTINGS);
                } catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

}

